/**
*
* MD Gallery v1 [build1.0]
* Copyright (c) 2007 D. Molanphy, Molanphy Design
* 
* This software may be used in personal and commercial projects provided the 
* source code retains the above copyright notice.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT 
* NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
* WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*
*
*/

//==============================================================================================
//---- FUNCTION TO DISPLAY ERROR MESSAGES
//==============================================================================================
function throwError(message:String):Void {
	if (!error_mc) {
		mainTL.attachMovie("mc.error", "error_mc", mainTL.getNextHighestDepth(), {_x:Stage.width/2, _y:Stage.height/2, _alpha:0})
		mainTL.error_mc.error_txt.text = message;
		mainTL.error_mc.alphaTo(100, 1, 'easeInOutSine');
		
		mainTL.error_mc.onRelease = mainTL.error_mc.onReleaseOutside = function() {
			enableThumbs(true);
			destroy(this);
			mainTL.large_mc.removeMovieClip();
			mainTL.bgroundBox_mc.alphaTo(0, 1, 'easeOutExpo', {func:destroy, args:[mainTL.bgroundBox_mc]});
		}
	}
};

//==============================================================================================
//---- FUNCTION TO ENABLE/DISABLE THUMBNAIL ACTIONS
//==============================================================================================
function enableThumbs(condition:Boolean):Void {
	for (var n:Number=0; n < thumbs_arr.length; n++) {
		thumbs_arr[n].holder.enabled = condition;
	}
};

//==============================================================================================
//---- FUNCTION TO DESTROY (REMOVE) MCs FROM STAGE
//==============================================================================================
function destroy(which:MovieClip):Void {
	which.removeMovieClip();
};



//==============================================================================================
//---- FUNCTION TO GET URL FROM DYNAMIC TEXT FIELDS
//==============================================================================================

function openURL(url:String):Void {
	mainTL.getURL(url, "_blank");
}
